//
//  Retrieving_Assets_from_the_Assets_LibraryViewController.m
//  Retrieving Assets from the Assets Library
//
//  Created by Vandad Nahavandipoor on 22/07/2011.
//  Copyright 2011 Pixolity Ltd. All rights reserved.
//

/* 1 */
//#import "Retrieving_Assets_from_the_Assets_LibraryViewController.h"
//
//@implementation Retrieving_Assets_from_the_Assets_LibraryViewController
//
//@synthesize assetsLibrary;
//
//- (void)viewDidLoad{
//  [super viewDidLoad];
//  self.assetsLibrary = [[ALAssetsLibrary alloc] init];
//  
//  [self.assetsLibrary 
//   enumerateGroupsWithTypes:ALAssetsGroupAll
//   usingBlock:^(ALAssetsGroup *group, BOOL *stop) {
//     [group enumerateAssetsUsingBlock:^(ALAsset *result, 
//                                        NSUInteger index, 
//                                        BOOL *stop) {
//       
//       /* Pobranie rodzaju zasobu. */
//       NSString *assetType = [result valueForProperty:ALAssetPropertyType];
//       
//       if ([assetType isEqualToString:ALAssetTypePhoto]){
//         NSLog(@"To jest zasób w postaci zdjęcia.");
//       }
//       
//       else if ([assetType isEqualToString:ALAssetTypeVideo]){
//         NSLog(@"To jest zasób w postaci filmu.");
//       }
//       
//       else if ([assetType isEqualToString:ALAssetTypeUnknown]){
//         NSLog(@"To jest zasób niewiadomego rodzaju.");
//       }
//       
//       /* Pobranie adresu URL zasobu. */
//       NSDictionary *assetURLs = [result valueForProperty:ALAssetPropertyURLs];
//       
//       NSUInteger    assetCounter = 0;
//       for (NSString *assetURLKey in assetURLs){
//         assetCounter++;
//         NSLog(@"Adres URL zasobu %lu = %@",
//               (unsigned long)assetCounter,
//               [assetURLs valueForKey:assetURLKey]);
//       }
//       
//       /* Pobranie obiektu reprezentacji zasobu. */
//       ALAssetRepresentation *assetRepresentation = 
//        [result defaultRepresentation];
//       
//       NSLog(@"Wielkość obiektu reprezentacji = %lld", [assetWielkość obiektu reprezentacji]);
//       
//     }];
//   } 
//   failureBlock:^(NSError *error) {
//     NSLog(@"Nie udało się pobrać grup zasobu.");
//   }];
//  
//}
//
//- (void)viewDidUnload{
//  [super viewDidUnload];
//  self.assetsLibrary = nil;
//}
//
//
//- (BOOL)shouldAutorotateToInterfaceOrientation
//        :(UIInterfaceOrientation)interfaceOrientation{
//  return YES;
//}
//
//@end

/* 2 */
//#import "Retrieving_Assets_from_the_Assets_LibraryViewController.h"
//
//@implementation Retrieving_Assets_from_the_Assets_LibraryViewController
//
//@synthesize assetsLibrary;
//@synthesize imageView;
//
//- (void)viewDidLoad{
//  [super viewDidLoad];
//  
//  self.view.backgroundColor = [UIColor whiteColor];
//  self.assetsLibrary = [[ALAssetsLibrary alloc] init];
//  
//  dispatch_queue_t dispatchQueue = 
//    dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0);
//  
//  dispatch_async(dispatchQueue, ^(void) {
//    
//    [self.assetsLibrary 
//     enumerateGroupsWithTypes:ALAssetsGroupAll
//     usingBlock:^(ALAssetsGroup *group, BOOL *stop) {
//       
//       [group enumerateAssetsUsingBlock:^(ALAsset *result, 
//                                          NSUInteger index, 
//                                          BOOL *stop) {
//         
//         __block BOOL foundThePhoto = NO;
//         
//         if (foundThePhoto){
//           *stop = YES;
//         }
//         
//         /* Pobranie rodzaju zasobu. */
//         NSString *assetType = [result valueForProperty:ALAssetPropertyType];
//         
//         if ([assetType isEqualToString:ALAssetTypePhoto]){
//           NSLog(@"To jest zasób w postaci zdjęcia.");
//           
//           foundThePhoto = YES;
//           *stop = YES;
//           
//           /* Pobranie obiektu reprezentacji zasobu. */
//           ALAssetRepresentation *assetRepresentation =
//            [result defaultRepresentation];
//           
//           /* Konieczne jest przeskalowanie i zmiana układu obrazu, aby na podstawie obiektu reprezentacji przygotować poprawny obiekt UIImage. */
//           CGFloat imageScale = [assetRepresentation scale];
//           
//           UIImageOrientation imageOrientation = 
//            (UIImageOrientation)[assetRepresentation orientation];
//           
//           dispatch_async(dispatch_get_main_queue(), ^(void) {
//             
//             CGImageRef imageReference = 
//              [assetRepresentation fullResolutionImage];
//             
//             /* Utworzenie obrazu. */
//             UIImage     *image =
//             [[UIImage alloc] initWithCGImage:imageReference
//                                        scale:imageScale
//                                  orientation:imageOrientation];
//             
//             if (image != nil){
//               self.imageView = [[UIImageView alloc] 
//                                 initWithFrame:self.view.bounds];
//               self.imageView.contentMode = UIViewContentModeScaleAspectFit;
//               self.imageView.image = image;
//               [self.view addSubview:self.imageView];
//               
//             } else {
//               NSLog(@"Nie udało się utworzyć obrazu.");
//             }
//           });
//           
//         }
//         
//       }];
//     } 
//     failureBlock:^(NSError *error) {
//       NSLog(@"Nie udało się pobrać grup zasobu.");
//     }];
//    
//  });
//  
//}
//
//- (void)viewDidUnload{
//  [super viewDidUnload];
//  self.assetsLibrary = nil;
//  self.imageView = nil;
//}
//
//
//- (BOOL)shouldAutorotateToInterfaceOrientation
//        :(UIInterfaceOrientation)interfaceOrientation{
//  return YES;
//}
//
//@end

/* 3 */
#import "Retrieving_Assets_from_the_Assets_LibraryViewController.h"

@implementation Retrieving_Assets_from_the_Assets_LibraryViewController

@synthesize assetsLibrary;

- (void)viewDidLoad{
  [super viewDidLoad];
  
  self.view.backgroundColor = [UIColor whiteColor];
  self.assetsLibrary = [[ALAssetsLibrary alloc] init];
  
  dispatch_queue_t dispatchQueue = 
  dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0);
  
  dispatch_async(dispatchQueue, ^(void) {
    
    [self.assetsLibrary 
     enumerateGroupsWithTypes:ALAssetsGroupAll
     usingBlock:^(ALAssetsGroup *group, BOOL *stop) {
       
       __block BOOL foundTheVideo = NO;
       
       [group enumerateAssetsUsingBlock:^(ALAsset *result, 
                                          NSUInteger index, 
                                          BOOL *stop) {
         
         /* Pobranie rodzaju zasobu. */
         NSString *assetType = [result valueForProperty:ALAssetPropertyType];
         
         if ([assetType isEqualToString:ALAssetTypeVideo]){
           NSLog(@"To jest zasób w postaci filmu.");
           
           foundTheVideo = YES;
           *stop = YES;
           
           /* Pobranie obiektu reprezentacji zasobu. */
           ALAssetRepresentation *assetRepresentation =
            [result defaultRepresentation];
           
           const NSUInteger BufferSize = 1024;
           uint8_t buffer[BufferSize];
           NSUInteger bytesRead = 0;
           long long currentOffset = 0;
           NSError *readingError = nil;
           
           /* Wyszukanie katalogu Documents (tablica). */
           NSArray *documents =
           NSSearchPathForDirectoriesInDomains(NSDocumentDirectory,
                                               NSUserDomainMask,
                                               YES);
           
           /* Pobranie wymaganego katalogu Documents. */
           NSString *documentsFolder = [documents objectAtIndex:0];
           
           /* Utworzenie ścieżki dostępu określającej położenie zapisu pliku filmu. */
           NSString *videoPath = [documentsFolder
                                  stringByAppendingPathComponent:@"Temp.MOV"];
           
           NSFileManager *fileManager = [[NSFileManager alloc] init];
           
           /* Utworzenie pliku, o ile jeszcze nie istnieje. */
           if ([fileManager fileExistsAtPath:videoPath] == NO){
             [fileManager createFileAtPath:videoPath
                                  contents:nil
                                attributes:nil];
           }
           
           /* Uchwyt pliku wykorzystamy do zapisu na dysku zawartości zasobu. */
           NSFileHandle *fileHandle = [NSFileHandle
                                       fileHandleForWritingAtPath:videoPath];
           
           do{
             
             /* Odczyt maksymalnej liczby bajtów, które można umieścić w buforze. */
             bytesRead = [assetRepresentation getBytes:(uint8_t *)&buffer
                                            fromOffset:currentOffset
                                                length:BufferSize
                                                 error:&readingError];
             
             /* Jeśli nie można odczytać żadnych bajtów, opuszczamy pętlę. */
             if (bytesRead == 0){
               break;
             }
             
             /* Śledzimy na bieżąco liczbę odczytanych bajtów. */
             currentOffset += bytesRead;
             
             /* Umieszczenie zawartości bufora w obiekcie NSData. */
             NSData *readData = [[NSData alloc]
                                 initWithBytes:(const void *)buffer
                                 length:bytesRead];
             
             /*Zapis danych w pliku. */
             [fileHandle writeData:readData];
             
           } while (bytesRead > 0);
           
           NSLog(@"Zakończono odczyt i zapips pliku filmu w katalogu Documents");
           
         }
         
       }];
       
       if (foundTheVideo){
         *stop = YES;
       }
       
     } 
     failureBlock:^(NSError *error) {
       NSLog(@"Nie udało się pobrać grup zasobu.");
     }];
    
  });
  
}

- (void)viewDidUnload{
  [super viewDidUnload];
  self.assetsLibrary = nil;
}

- (BOOL)shouldAutorotateToInterfaceOrientation
        :(UIInterfaceOrientation)interfaceOrientation{
  return YES;
}

@end